script_dir=$(realpath $(dirname "$0"))

cd $script_dir/../
if [ ! -f cert.pem ] || [ ! -f key.pem ]; then
    # create self-signed certificate for https server.
    openssl req -x509 -newkey rsa:2048 -keyout key.pem -out cert.pem -days 365 -nodes
fi

yarn build
echo "start the server with https protocol."
npx serve -s build --ssl-cert cert.pem --ssl-key key.pem
